<?php
// school_admission/views/templates/application_data_template.php
// This file is designed to be INCLUDED by print_application_data.php
// It expects the $applicant_data, $academic_records, $passport_photo_path, $branch_data, $course_data variables to be available.

if (!isset($applicant_data) || !isset($academic_records) || !isset($branch_data) || !isset($course_data)) {
    die("Application Data template not called correctly. Missing data.");
}

// Helper to get grade if it exists, otherwise N/A
function get_o_level_grade($subject_name, $academic_records) {
    foreach ($academic_records as $record) {
        if (strcasecmp($record['subject'], $subject_name) == 0) { // Case-insensitive comparison
            return htmlspecialchars($record['grade']);
        }
    }
    return ''; // Return empty string if not found for printing alignment
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Applicant Data Printout</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            font-family: 'Times New Roman', serif;
            margin: 0;
            padding: 0;
            background-color: #f0f0f0;
            color: #000;
            line-height: 1.4;
        }
        .print-container {
            width: 210mm; /* A4 width */
            min-height: 297mm; /* A4 height */
            margin: 10mm auto; /* Smaller margin for print efficiency */
            padding: 15mm;
            background: white;
            border: 1px solid #aaa;
            box-shadow: 0 0 8px rgba(0,0,0,0.1);
            box-sizing: border-box;
            position: relative;
        }
        .header-section {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 1px solid #ccc;
            padding-bottom: 10px;
        }
        .header-section h1 {
            font-size: 20px;
            margin: 0;
            color: #000;
            text-transform: uppercase;
        }
        .header-section p {
            font-size: 12px;
            margin: 2px 0;
            color: #333;
        }
        .header-section .collaboration {
            font-size: 14px;
            font-weight: bold;
            margin: 10px 0;
            color: #0056b3;
            border: 1px solid #0056b3;
            padding: 5px;
            display: inline-block;
        }
        .application-data-title {
            font-size: 16px;
            font-weight: bold;
            text-align: center;
            margin: 15px 0 10px 0;
            text-decoration: underline;
        }
        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }
        .info-table td {
            border: 1px solid #000;
            padding: 4px 6px;
            font-size: 12px;
            vertical-align: top;
            height: 20px; /* Ensure consistent row height */
        }
        .info-table .label {
            font-weight: bold;
            width: 20%; /* Adjust label width as needed */
            background-color: #f2f2f2; /* Light background for labels */
        }
        .info-table .value {
            width: 30%;
        }
        .info-table .full-width-value {
            width: 80%;
        }

        .section-heading {
            font-size: 14px;
            font-weight: bold;
            margin-top: 15px;
            margin-bottom: 5px;
            border-bottom: 1px solid #000;
            padding-bottom: 3px;
        }
        .o-level-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        .o-level-table th, .o-level-table td {
            border: 1px solid #000;
            padding: 4px 6px;
            font-size: 12px;
            text-align: left;
        }
        .o-level-table th {
            background-color: #e0e0e0;
            font-weight: bold;
            text-align: center;
        }
        .passport-photo {
            position: absolute;
            top: 20mm; /* Position from top of print container */
            right: 15mm; /* Position from right of print container */
            width: 70px; /* Standard passport photo size */
            height: 85px; /* Standard passport photo size */
            border: 1px solid #000;
            object-fit: cover;
            background-color: #f9f9f9;
        }
        .official-only {
            margin-top: 25px;
            font-size: 14px;
            font-weight: bold;
            border-bottom: 1px solid #000;
            padding-bottom: 3px;
        }
        .print-button-container {
            text-align: center;
            margin: 10px auto 20px auto;
            max-width: 210mm;
        }
        .print-button {
            background-color: #007bff;
            color: white;
            padding: 8px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            font-family: Arial, sans-serif;
            margin: 0 5px;
            transition: background-color 0.3s ease;
        }
        .print-button:hover {
            background-color: #0056b3;
        }

        /* Print Specific Styles */
        @media print {
            body {
                margin: 0;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            .print-button-container {
                display: none; /* Hide the print button when printing */
            }
            .print-container {
                margin: 0;
                border: none;
                box-shadow: none;
                width: 210mm;
                height: 297mm;
                padding: 15mm;
            }
        }
    </style>
</head>
<body>
    <div class="print-button-container">
        <button class="print-button" onclick="window.print()"><i class="fas fa-print"></i> Print Application Data</button>
        <button class="print-button" style="background-color: #6c757d;" onclick="window.close()"><i class="fas fa-times-circle"></i> Close Window</button>
    </div>
    <div class="print-container">
        <div class="header-section">
            <h1>MINNA INSTITUTE OF TECHNOLOGY AND INNOVATION</h1>
            <p>SKILLS FOR SELF RELIANCE</p>
            <div class="collaboration">IN COLLABORATION WITH</div>
            <p><strong><?php echo htmlspecialchars(strtoupper($branch_data['branch_name'])); ?></strong></p>
            <p><?php echo htmlspecialchars($branch_data['location']); ?></p>
        </div>

        <div class="application-data-title">APPLICATION DATA</div>

        <table class="info-table">
            <tr>
                <td class="label">APPLICATION NO:</td>
                <td class="full-width-value" colspan="3"><?php echo htmlspecialchars($applicant_data['application_no']); ?></td>
            </tr>
            <tr>
                <td class="label">PROGRAMME:</td>
                <td class="full-width-value" colspan="3"><?php echo htmlspecialchars($course_data['course_name']); ?></td>
            </tr>
            <tr>
                <td class="label">STUDY MODE:</td>
                <td class="full-width-value" colspan="3">FULL-TIME</td> <!-- Assuming full-time as per image, or use $applicant_data['study_mode'] if you add it -->
            </tr>
        </table>
        
        <?php if ($passport_photo_path): ?>
            <img src="<?php echo htmlspecialchars($passport_photo_path); ?>" alt="Applicant Passport" class="passport-photo">
        <?php endif; ?>

        <div class="section-heading">Personal Data</div>
        <table class="info-table">
            <tr>
                <td class="label">Applicant Name:</td>
                <td class="value"><?php echo htmlspecialchars($applicant_data['first_name'] . ' ' . $applicant_data['last_name'] . ' ' . $applicant_data['other_names']); ?></td>
                <td class="label">Date of Birth:</td>
                <td class="value"><?php echo date('d/m/Y', strtotime($applicant_data['date_of_birth'])); ?></td>
            </tr>
            <tr>
                <td class="label">Gender:</td>
                <td class="value"><?php echo htmlspecialchars($applicant_data['gender']); ?></td>
                <td class="label">Marital Status:</td>
                <td class="value"><?php echo htmlspecialchars($applicant_data['marital_status']); ?></td>
            </tr>
            <tr>
                <td class="label">Phone Number:</td>
                <td class="value"><?php echo htmlspecialchars($applicant_data['phone_number']); ?></td>
                <td class="label">Country:</td>
                <td class="value">NIGERIA</td> <!-- Hardcoded as per image -->
            </tr>
            <tr>
                <td class="label">State:</td>
                <td class="value">NIGER</td> <!-- Hardcoded as per image -->
                <td class="label">LGA:</td>
                <td class="value">BORGU</td> <!-- Hardcoded as per image, consider using dynamic if added to DB -->
            </tr>
            <tr>
                <td class="label">Tribe:</td>
                <td class="value"><?php echo htmlspecialchars($applicant_data['tribe']); ?></td>
                <td class="label">Email:</td>
                <td class="value"><?php echo htmlspecialchars($applicant_data['email']); ?></td>
            </tr>
            <tr>
                <td class="label">Address:</td>
                <td class="full-width-value" colspan="3"><?php echo nl2br(htmlspecialchars($applicant_data['address'])); ?></td>
            </tr>
        </table>

        <div class="section-heading">Parent/Guardian Data</div>
        <table class="info-table">
            <tr>
                <td class="label">Name:</td>
                <td class="value"><?php echo htmlspecialchars($applicant_data['parent_guardian_name']); ?></td>
                <td class="label">Contact:</td>
                <td class="value"><?php echo htmlspecialchars($applicant_data['parent_guardian_contact']); ?></td>
            </tr>
            <tr>
                <td class="label">Relationship:</td>
                <td class="value"><?php echo htmlspecialchars($applicant_data['parent_guardian_relationship']); ?></td>
                <td class="label">Address:</td>
                <td class="value"><?php echo nl2br(htmlspecialchars($applicant_data['parent_guardian_address'])); ?></td>
            </tr>
        </table>

        <div class="section-heading">O'Level Details</div>
        <table class="o-level-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Subject</th>
                    <th>Grade</th>
                    <th>Body</th> <!-- Assuming Body refers to exam body, e.g., WAEC/NECO -->
                    <th>Date</th> <!-- Assuming Date refers to exam year -->
                </tr>
            </thead>
            <tbody>
                <?php
                // List of common subjects from the image, you can expand this if needed
                $common_subjects = ['ECONOMICS', 'GEOGRAPHY', 'ENGLISH LANGUAGE', 'MATHEMATICS', 'BIOLOGY', 'CHEMISTRY', 'PHYSICS'];
                $i = 1;
                foreach ($common_subjects as $subject):
                    $grade = get_o_level_grade($subject, $academic_records);
                    $record_found = false;
                    $exam_body = '';
                    $exam_year = '';
                    foreach ($academic_records as $record_item) {
                        if (strcasecmp($record_item['subject'], $subject) == 0) {
                            $exam_body = htmlspecialchars($record_item['exam_type']);
                            $exam_year = htmlspecialchars($record_item['exam_year']);
                            $record_found = true;
                            break;
                        }
                    }
                ?>
                    <tr>
                        <td style="text-align:center;"><?php echo $i++; ?></td>
                        <td><?php echo htmlspecialchars($subject); ?></td>
                        <td style="text-align:center;"><?php echo $grade; ?></td>
                        <td style="text-align:center;"><?php echo $exam_body; ?></td>
                        <td style="text-align:center;"><?php echo $exam_year; ?></td>
                    </tr>
                <?php endforeach; ?>
                <?php if (count($academic_records) > count($common_subjects)): ?>
                    <?php
                    // Add any other subjects not in common_subjects list
                    foreach ($academic_records as $record_item):
                        if (!in_array(strtoupper($record_item['subject']), $common_subjects)):
                    ?>
                        <tr>
                            <td style="text-align:center;"><?php echo $i++; ?></td>
                            <td><?php echo htmlspecialchars($record_item['subject']); ?></td>
                            <td style="text-align:center;"><?php echo htmlspecialchars($record_item['grade']); ?></td>
                            <td style="text-align:center;"><?php echo htmlspecialchars($record_item['exam_type']); ?></td>
                            <td style="text-align:center;"><?php echo htmlspecialchars($record_item['exam_year']); ?></td>
                        </tr>
                        <?php
                        endif;
                    endforeach;
                endif;
                ?>
            </tbody>
        </table>

        <div class="official-only">Official Only</div>
        <!-- You can add official stamps/signatures here if needed -->

    </div>
</body>
</html>