<?php
// school_admission/views/templates/admission_letter_template.php
// This file is designed to be INCLUDED by admin_approve_application_action.php
// It expects the $applicant_data and $registrar_name variables to be available.

if (!isset($applicant_data) || !isset($registrar_name)) {
    die("Admission letter template not called correctly. Missing data.");
}

$admission_date = date('d-F-Y', strtotime($applicant_data['approval_date']));
$registration_deadline = date('d-F-Y', strtotime($applicant_data['approval_date'] . ' +2 weeks')); // 2 weeks from approval date
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Provisional Admission Letter</title>
    <style>
        body {
            font-family: 'Times New Roman', serif;
            margin: 0;
            padding: 0;
            background-color: #f9f9f9;
            color: #333;
            line-height: 1.6;
        }
        .print-area { /* This new div will wrap content to be printed */
            width: 210mm; /* A4 width */
            min-height: 297mm; /* A4 height */
            margin: 20mm auto;
            padding: 25mm;
            background: white;
            border: 1px solid #ccc;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            box-sizing: border-box;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .header img {
            max-width: 100px; /* Adjust logo size */
            margin-bottom: 10px;
        }
        .header h1 {
            font-size: 28px;
            color: #0056b3;
            margin: 0;
            text-transform: uppercase;
        }
        .header h2 {
            font-size: 18px;
            color: #555;
            margin: 5px 0;
            font-weight: normal;
        }
        .header p {
            font-size: 14px;
            color: #777;
            margin: 2px 0;
        }
        .title {
            text-align: center;
            font-size: 24px;
            font-weight: bold;
            margin: 40px 0;
            text-decoration: underline;
            color: #0056b3;
        }
        .content {
            font-size: 16px;
            margin-bottom: 20px;
        }
        .content p {
            margin-bottom: 15px;
            text-align: justify;
        }
        .details-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        .details-table td {
            padding: 8px 0;
            vertical-align: top;
        }
        .details-table td:first-child {
            font-weight: bold;
            width: 30%;
        }
        .requirements {
            margin-top: 30px;
            margin-bottom: 30px;
        }
        .requirements ul {
            list-style: disc;
            margin-left: 20px;
            padding: 0;
        }
        .requirements ul li {
            margin-bottom: 8px;
            text-align: justify;
        }
        .signature {
            margin-top: 50px;
            text-align: left;
        }
        .signature img {
            max-width: 150px; /* Adjust signature image size */
            display: block;
            margin-bottom: 5px;
        }
        .signature p {
            margin: 0;
            font-weight: bold;
            border-top: 1px solid #000;
            padding-top: 5px;
            display: inline-block;
        }
        .footer {
            text-align: center;
            margin-top: 40px;
            font-size: 12px;
            color: #777;
        }

        /* Print Button Styles (visible on screen, hidden on print) */
        .print-button-container {
            text-align: center;
            margin: 20px auto;
            max-width: 210mm; /* Match letter width for centering */
        }
        .print-button {
            background-color: #007bff;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            font-family: Arial, sans-serif;
            transition: background-color 0.3s ease;
        }
        .print-button:hover {
            background-color: #0056b3;
        }

        /* Print Specific Styles */
        @media print {
            body {
                margin: 0;
                -webkit-print-color-adjust: exact; /* Ensure background colors are printed */
                print-color-adjust: exact;
            }
            .print-button-container {
                display: none; /* Hide the print button when printing */
            }
            .print-area {
                margin: 0;
                border: none;
                box-shadow: none;
                width: 210mm;
                height: 297mm;
                padding: 15mm; /* Adjust padding for better print margins if needed */
            }
        }
    </style>
</head>
<body>
    <div class="print-button-container">
        <button class="print-button" onclick="window.print()"><i class="fas fa-print"></i> Print Admission Letter</button>
        <button class="print-button" style="background-color: #6c757d;" onclick="window.close()"><i class="fas fa-times-circle"></i> Close Window</button>
    </div>
    <div class="print-area">
        <div class="header">
            <!-- You can add your MITI logo here if you have one in public/assets -->
            <!-- <img src="/school_admission/public/assets/miti_logo.png" alt="MITI Logo"> -->
            <h1>MINNA INSTITUTE OF TECHNOLOGY AND INNOVATION</h1>
            <h2>SKILLS FOR SELF RELIANCE</h2>
            <p>OPP. OLD SECRETARIAT, KETEREN, GWARI RD. MINNA, NIGER STATE.</p>
        </div>

        <div class="title">
            OFFER OF PROVISIONAL ADMISSION <?php echo date('Y', strtotime($applicant_data['application_date'])); ?>/<?php echo date('Y', strtotime($applicant_data['application_date'])) + 1; ?>
        </div>

        <div class="content">
            <p>Date: <?php echo $admission_date; ?></p>
            <p>I write to inform you that you have been offered provisional admission, as indicated below, subject to meeting all registration requirements.</p>

            <table class="details-table">
                <tr>
                    <td>Name:</td>
                    <td><strong><?php echo htmlspecialchars(strtoupper($applicant_data['first_name'] . ' ' . $applicant_data['last_name'] . ' ' . $applicant_data['other_names'])); ?></strong></td>
                </tr>
                <tr>
                    <td>Application No:</td>
                    <td><strong><?php echo htmlspecialchars($applicant_data['application_no']); ?></strong></td>
                </tr>
                <tr>
                    <td>Level:</td>
                    <td><strong><?php echo htmlspecialchars($applicant_data['level']); ?></strong></td>
                </tr>
                <tr>
                    <td>Course:</td>
                    <td><strong><?php echo htmlspecialchars(strtoupper($applicant_data['course_name'])); ?></strong></td>
                </tr>
            </table>

            <p>This is subject to meeting the following requirements: You MUST ensure that you complete the registration process within the stipulated period. For the purpose of screening and documentation, you are required to bring along the under listed items.</p>

            <div class="requirements">
                <ul>
                    <li>Proceed to the Department for verification of original credentials.</li>
                    <li>Photocopies of Credentials (Primary School Certificate, Secondary School Certificate and L.G.A)</li>
                    <li>Complete your registration within two(2) weeks from the date of this offer (i.e., by **<?php echo $registration_deadline; ?>**).</li>
                </ul>
            </div>

            <p>Ensure that the particulars and the information you are providing are correct in every respect. If at any time, it is discovered that you do not satisfy the minimum entry requirements prescribed for the course of the study at the time of this offer, or that any of the qualifications you claimed to have is false or incorrect, you will be required to withdraw from the school.</p>

            <p>The name by which you are hereby admitted and by which you will be registered is the one that will appear on any certificate that the school may issue to you on successful completion of your programme.</p>

            <p>Candidates are hereby informed that fees must be paid at the beginning of the session.</p>

            <p>All fees paid are non-refundable.</p>

            <p>Please accept our congratulations.</p>
        </div>

        <div class="signature">
            <!-- If you have a scanned signature image for the Registrar, you can place it here -->
            <!-- <img src="/school_admission/public/assets/registrar_signature.png" alt="Registrar Signature"> -->
            <p><?php echo htmlspecialchars($registrar_name); ?></p>
            <p style="border:none;">Registrar</p>
        </div>

        <div class="footer">
            <p>Minna Institute of Technology and Innovation &copy; <?php echo date('Y'); ?></p>
        </div>
    </div>
</body>
</html>