<?php
// school_admission/views/branch/dashboard_content.php
// This file assumes $conn is available from the main public/*.php file.

$branch_id = $_SESSION['branch_id'];

// Fetch some data for the dashboard relevant to the branch
$totalApplicantsBranch = 0;
$pendingApplicantsBranch = 0;
$approvedApplicantsBranch = 0;

$stmtTotal = $conn->prepare("SELECT COUNT(*) AS total FROM applicants WHERE branch_id = ?");
$stmtPending = $conn->prepare("SELECT COUNT(*) AS total FROM applicants WHERE branch_id = ? AND status = 'pending_review'");
$stmtApproved = $conn->prepare("SELECT COUNT(*) AS total FROM applicants WHERE branch_id = ? AND status = 'approved'");

if ($stmtTotal && $stmtPending && $stmtApproved) {
    $stmtTotal->bind_param("i", $branch_id);
    $stmtTotal->execute();
    $resultTotal = $stmtTotal->get_result();
    if ($resultTotal) $totalApplicantsBranch = $resultTotal->fetch_assoc()['total'];
    $stmtTotal->close();

    $stmtPending->bind_param("i", $branch_id);
    $stmtPending->execute();
    $resultPending = $stmtPending->get_result();
    if ($resultPending) $pendingApplicantsBranch = $resultPending->fetch_assoc()['total'];
    $stmtPending->close();

    $stmtApproved->bind_param("i", $branch_id);
    $stmtApproved->execute();
    $resultApproved = $stmtApproved->get_result();
    if ($resultApproved) $approvedApplicantsBranch = $resultApproved->fetch_assoc()['total'];
    $stmtApproved->close();
}
?>

<div class="dashboard-grid">
    <div class="dashboard-card">
        <h3>Total Applicants (My Branch)</h3>
        <p><?php echo $totalApplicantsBranch; ?></p>
    </div>
    <div class="dashboard-card">
        <h3>Pending Applications (My Branch)</h3>
        <p><?php echo $pendingApplicantsBranch; ?></p>
    </div>
    <div class="dashboard-card">
        <h3>Approved Applications (My Branch)</h3>
        <p><?php echo $approvedApplicantsBranch; ?></p>
    </div>
</div>

<div class="mt-20">
    <h3>Quick Actions</h3>
    <p>
        <!-- Update all links to direct public/*.php files -->
        <a href="branch_add_applicant.php" class="btn btn-primary">Add New Applicant</a>
        <a href="branch_view_applicants.php" class="btn btn-primary">View My Applicants</a>
        <a href="branch_print_letter.php" class="btn btn-primary">Print Admission Letters</a>
        <!-- Add links for recording payments if you implement that view -->
    </p>
</div>