<?php
// school_admission/views/admin/dashboard_content.php
// This file assumes $conn is available from the main public/*.php file.

// Fetch some data for the dashboard
$totalApplicants = 0;
$pendingApplications = 0;
$approvedApplications = 0;
$totalBranches = 0;
$totalCourses = 0;
$totalUsers = 0;

$queryApplicants = "SELECT COUNT(*) AS total FROM applicants";
$queryPending = "SELECT COUNT(*) AS total FROM applicants WHERE status = 'pending_review'";
$queryApproved = "SELECT COUNT(*) AS total FROM applicants WHERE status = 'approved'";
$queryBranches = "SELECT COUNT(*) AS total FROM branches";
$queryCourses = "SELECT COUNT(*) AS total FROM courses";
$queryUsers = "SELECT COUNT(*) AS total FROM users";


$resultApplicants = $conn->query($queryApplicants);
if ($resultApplicants) {
    $totalApplicants = $resultApplicants->fetch_assoc()['total'];
}

$resultPending = $conn->query($queryPending);
if ($resultPending) {
    $pendingApplications = $resultPending->fetch_assoc()['total'];
}

$resultApproved = $conn->query($queryApproved);
if ($resultApproved) {
    $approvedApplications = $resultApproved->fetch_assoc()['total'];
}

$resultBranches = $conn->query($queryBranches);
if ($resultBranches) {
    $totalBranches = $resultBranches->fetch_assoc()['total'];
}

$resultCourses = $conn->query($queryCourses);
if ($resultCourses) {
    $totalCourses = $resultCourses->fetch_assoc()['total'];
}

$resultUsers = $conn->query($queryUsers);
if ($resultUsers) {
    $totalUsers = $resultUsers->fetch_assoc()['total'];
}
?>

<div class="dashboard-grid">
    <div class="dashboard-card">
        <h3>Total Applicants</h3>
        <p><?php echo $totalApplicants; ?></p>
    </div>
    <div class="dashboard-card">
        <h3>Pending Applications</h3>
        <p><?php echo $pendingApplications; ?></p>
    </div>
    <div class="dashboard-card">
        <h3>Approved Applications</h3>
        <p><?php echo $approvedApplications; ?></p>
    </div>
    <div class="dashboard-card">
        <h3>Total Branches</h3>
        <p><?php echo $totalBranches; ?></p>
    </div>
    <div class="dashboard-card">
        <h3>Total Courses</h3>
        <p><?php echo $totalCourses; ?></p>
    </div>
    <div class="dashboard-card">
        <h3>Total Users</h3>
        <p><?php echo $totalUsers; ?></p>
    </div>
</div>

<div class="mt-20">
    <h3>Quick Actions</h3>
    <p>
        <!-- Update all links to direct public/*.php files -->
        <a href="admin_view_applications.php" class="btn btn-primary">View All Applications</a>
        <a href="admin_manage_branches.php" class="btn btn-primary">Manage Branches</a>
        <a href="admin_manage_courses.php" class="btn btn-primary">Manage Courses</a>
        <a href="admin_manage_users.php" class="btn btn-primary">Manage Users</a>
    </p>
</div>