<?php
// school_admission/public/test_auth.php
// --- DEBUGGING LINES START ---
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// --- DEBUGGING LINES END ---

echo "<h1>Auth Check Include Test</h1>";
echo "<p>Attempting to include auth_check.php from: " . __DIR__ . "</p>";

$authCheckPath = __DIR__ . '/../includes/auth_check.php';
echo "<p>Calculated path to auth_check.php: " . htmlspecialchars($authCheckPath) . "</p>";

if (file_exists($authCheckPath)) {
    echo "<p style='color:green;'>1. auth_check.php file <span style='font-weight:bold;'>EXISTS</span> at this path!</p>";

    // Try to include it
    require_once $authCheckPath;

    // Now check if the function exists
    if (function_exists('requireAnyRole')) {
        echo "<p style='color:green;'>2. The function <span style='font-weight:bold;'>'requireAnyRole()' IS DEFINED!</span></p>";
        echo "<p>Test Passed! The issue is likely resolved or elsewhere.</p>";
    } else {
        echo "<p style='color:red;'>2. CRITICAL: The function <span style='font-weight:bold;'>'requireAnyRole()' is NOT DEFINED</span> even after including auth_check.php. This indicates a problem within auth_check.php itself (e.g., syntax error, not saved correctly).</p>";
    }

} else {
    echo "<p style='color:red;'>1. CRITICAL: auth_check.php file <span style='font-weight:bold;'>DOES NOT EXIST</span> at the calculated path. Please check your folder structure and file names.</p>";
    echo "<p>Expected Path: " . htmlspecialchars($authCheckPath) . "</p>";
}

echo "<hr><p>Please copy the exact output from this page and paste it here.</p>";
?>