// school_admission/public/js/script.js

document.addEventListener('DOMContentLoaded', function() {
    // Mobile Navigation Toggle
    const menuToggle = document.querySelector('.menu-toggle');
    const mainNav = document.querySelector('.main-nav');

    if (menuToggle && mainNav) {
        menuToggle.addEventListener('click', function() {
            mainNav.classList.toggle('nav-open');
            menuToggle.classList.toggle('is-active'); // For hamburger animation
        });

        // Close nav when a link is clicked (optional, but good for UX)
        const navLinks = document.querySelectorAll('.main-nav .nav-list a');
        navLinks.forEach(link => {
            link.addEventListener('click', function() {
                if (mainNav.classList.contains('nav-open')) {
                    mainNav.classList.remove('nav-open');
                    menuToggle.classList.remove('is-active');
                }
            });
        });
    }

    // Example: Dynamic form elements (e.g., for adding multiple academic records)
    const addRecordBtn = document.getElementById('addAcademicRecord');
    const academicRecordsContainer = document.getElementById('academicRecordsContainer');

    if (addRecordBtn && academicRecordsContainer) {
        let recordCount = academicRecordsContainer.children.length; // Count existing records
        if (recordCount === 0) { // If no initial record, start from 0 for correct indexing
            recordCount = 0;
        } else { // If there are existing records, ensure new ones are correctly indexed
            const lastRecord = academicRecordsContainer.lastElementChild;
            const lastIndexMatch = lastRecord.id.match(/academic-record-(\d+)/);
            if (lastIndexMatch && lastIndexMatch[1]) {
                recordCount = parseInt(lastIndexMatch[1]);
            }
        }


        addRecordBtn.addEventListener('click', function() {
            recordCount++;
            const newRecordHtml = `
                <div class="academic-record-item form-group" id="academic-record-${recordCount}">
                    <h3>Academic Record #${recordCount}</h3>
                    <label for="academic_records_${recordCount}_exam_type">Exam Type:</label>
                    <select id="academic_records_${recordCount}_exam_type" name="academic_records[${recordCount}][exam_type]" required>
                        <option value="">Select Exam Type</option>
                        <option value="WAEC">WAEC</option>
                        <option value="NECO">NECO</option>
                        <option value="Others">Others</option>
                    </select>

                    <label for="academic_records_${recordCount}_exam_year">Exam Year:</label>
                    <input type="number" id="academic_records_${recordCount}_exam_year" name="academic_records[${recordCount}][exam_year]" placeholder="e.g., 2023" required>

                    <label for="academic_records_${recordCount}_subject">Subject:</label>
                    <input type="text" id="academic_records_${recordCount}_subject" name="academic_records[${recordCount}][subject]" placeholder="e.g., Mathematics" required>

                    <label for="academic_records_${recordCount}_grade">Grade:</label>
                    <input type="text" id="academic_records_${recordCount}_grade" name="academic_records[${recordCount}][grade]" placeholder="e.g., A1, B2, C6" required>

                    <label for="academic_records_${recordCount}_attachment">Result Slip (PDF/Image):</label>
                    <input type="file" id="academic_records_${recordCount}_attachment" name="academic_records[${recordCount}][attachment]" accept=".pdf,.jpg,.jpeg,.png">
                </div>
            `;
            academicRecordsContainer.insertAdjacentHTML('beforeend', newRecordHtml);
        });
    }

    // Confirmation for delete actions (you'll use this with PHP forms)
    const deleteButtons = document.querySelectorAll('.confirm-delete');
    deleteButtons.forEach(button => {
        button.addEventListener('click', function(event) {
            if (!confirm('Are you sure you want to delete this item? This action cannot be undone.')) {
                event.preventDefault();
            }
        });
    });

    // You can add more interactive JavaScript here
});