<?php
// school_admission/public/index.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once __DIR__ . '/../config/db.php'; // Included for potential future dynamic content, though not strictly needed for this simple page.
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/auth_check.php';

// If a user is already logged in, redirect them to their dashboard
if (isLoggedIn()) {
    redirect('dashboard.php');
}

include __DIR__ . '/../includes/header.php'; // Includes the header with navigation
?>

<div class="landing-hero">
    <div class="container text-center">
        <h2>Welcome to MITI Admission Portal</h2>
        <p>Your gateway to quality technical education and innovation.</p>
        <div class="hero-actions mt-30">
            <a href="login.php" class="btn btn-primary btn-lg"><i class="fas fa-sign-in-alt"></i> Login to Your Account</a>
            <a href="about.php" class="btn btn-info btn-lg"><i class="fas fa-info-circle"></i> Learn More About Us</a>
        </div>
    </div>
</div>

<div class="container mt-50">
    <div class="info-sections">
        <div class="info-card">
            <i class="fas fa-graduation-cap icon-large"></i>
            <h3>Our Programs</h3>
            <p>Explore a wide range of National Innovative Diploma (NID) programs designed to equip you with essential skills for self-reliance and national development.</p>
            <a href="about.php#courses" class="btn btn-secondary btn-sm">View Courses</a>
        </div>
        <div class="info-card">
            <i class="fas fa-university icon-large"></i>
            <h3>Our Mission</h3>
            <p>To provide accessible, high-quality, and market-driven technical and vocational education and training for youth empowerment and industrial growth.</p>
            <a href="about.php" class="btn btn-secondary btn-sm">Read More</a>
        </div>
        <div class="info-card">
            <i class="fas fa-map-marker-alt icon-large"></i>
            <h3>Visit Us</h3>
            <p>Located at Opp. Old Secretariat, Keteren, Gwari Rd, Minna, Niger State. We have branches in various communities.</p>
            <a href="about.php#contact" class="btn btn-secondary btn-sm">Contact Info</a>
        </div>
    </div>
</div>

<style>
/* Additional CSS for the landing page */
.landing-hero {
    background: linear-gradient(90deg, #5A2D2B 0%, #AF4C45 100%), url('/school_admission/public/assets/hero-bg.jpg') no-repeat center center/cover; /* Example background */
    color: white;
    padding: 100px 20px;
    margin-bottom: 50px;
    border-radius: 12px; /* Soften edges */
    text-shadow: 2px 2px 4px rgba(0,0,0,0.4);
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
}

.landing-hero h2 {
    font-size: 3.5em;
    margin-bottom: 20px;
    font-weight: 700;
    color: white; /* Override default heading color */
    border-bottom: none;
    padding-bottom: 0;
}

.landing-hero p {
    font-size: 1.5em;
    max-width: 800px;
    margin: 0 auto 30px auto;
    line-height: 1.4;
}

.hero-actions .btn {
    margin: 0 15px;
    padding: 15px 30px;
    font-size: 1.2em;
    border-radius: 50px; /* Pill-shaped buttons */
    box-shadow: 0 4px 10px rgba(0,0,0,0.2);
    text-transform: uppercase;
    font-weight: 600;
}

.hero-actions .btn-primary {
    background: linear-gradient(to right, #770303ff, #e75e2dff); /* Teal for info */
    border-color: #efefefff;
}
.hero-actions .btn-primary:hover {
     background: linear-gradient(to left, #770303ff, #e75e2dff); /* Teal for info */
    border-color: #480e03ff;
}

.hero-actions .btn-info {
    background: linear-gradient(to right, #770303ff, #e75e2dff); /* Teal for info */
    border-color: #17a2b8;
}
.hero-actions .btn-info:hover {
    background: linear-gradient(to right, #770303ff, #e75e2dff); /* Teal for info */
    border-color: #4d0505ff;
}

.info-sections {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 30px;
}

.info-card {
    background-color: white;
    padding: 35px;
    border-radius: 12px;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
    text-align: center;
    border: 1px solid #e0e0e0;
    transition: transform 0.3s ease-out, box-shadow 0.3s ease-out;
}

.info-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
}

.info-card .icon-large {
    font-size: 3.5em;
    color: #71160eff;
    margin-bottom: 20px;
    transition: color 0.3s ease;
}
.info-card:hover .icon-large {
    color: #551302ff;
}

.info-card h3 {
    font-size: 1.8em;
    color: #71160eff;
    margin-bottom: 15px;
}

.info-card p {
    font-size: 1.05em;
    color: #71160eff;
    margin-bottom: 25px;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .landing-hero {
        padding: 80px 15px;
    }
    .landing-hero h2 {
        font-size: 2.5em;
    }
    .landing-hero p {
        font-size: 1.2em;
    }
    .hero-actions .btn {
        margin: 10px 0;
        width: 100%;
    }
    .info-sections {
        grid-template-columns: 1fr;
    }
}
@media (max-width: 576px) {
    .landing-hero h2 {
        font-size: 2em;
    }
    .landing-hero p {
        font-size: 1em;
    }
}

</style>

<?php
include __DIR__ . '/../includes/footer.php';
$conn->close();
?>