<?php
// school_admission/public/dashboard.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/auth_check.php';

requireLogin(); // Ensure user is logged in

include __DIR__ . '/../includes/header.php';

echo '<h2 class="mt-20">Dashboard</h2>';
echo '<p>Welcome, ' . $_SESSION['username'] . ' (' . $_SESSION['role'] . ')</p>';

if (hasRole('super_admin')) {
    include __DIR__ . '/../views/admin/dashboard_content.php'; // Include only the content part
} elseif (hasRole('branch_admin')) {
    include __DIR__ . '/../views/branch/dashboard_content.php'; // Include only the content part
} else {
    echo "<p>Your role: " . $_SESSION['role'] . "</p>";
}

include __DIR__ . '/../includes/footer.php';
$conn->close(); // Close connection after everything
?>