<?php
// school_admission/public/admin_manage_users.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/auth_check.php';

requireRole(['super_admin']); // Only Super Admin can access this page

$message = '';
if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    unset($_SESSION['message']);
}

// Fetch all users
$users = [];
$sql = "SELECT u.user_id, u.username, u.email, u.role, b.branch_name
        FROM users u
        LEFT JOIN branches b ON u.branch_id = b.branch_id
        ORDER BY u.username ASC";
$result = $conn->query($sql);

if ($result) {
    while ($row = $result->fetch_assoc()) {
        $users[] = $row;
    }
    $result->free();
} else {
    $message = "<div class='message error'>Error fetching users: " . $conn->error . "</div>";
}

include __DIR__ . '/../includes/header.php';
?>

<h2 class="mt-30">Manage Users</h2>

<?php if (!empty($message)): ?>
    <?php echo $message; ?>
<?php endif; ?>

<div class="mb-20">
    <a href="admin_add_user.php" class="btn btn-success"><i class="fas fa-user-plus"></i> Add New User</a>
</div>

<?php if (empty($users)): ?>
    <div class="message info">No users found. Please add a new user.</div>
<?php else: ?>
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Username</th>
                <th>Email</th>
                <th>Role</th>
                <th>Associated Branch</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($users as $user): ?>
                <tr>
                    <td data-label="ID"><?php echo htmlspecialchars($user['user_id']); ?></td>
                    <td data-label="Username"><?php echo htmlspecialchars($user['username']); ?></td>
                    <td data-label="Email"><?php echo htmlspecialchars($user['email']); ?></td>
                    <td data-label="Role"><?php echo htmlspecialchars(ucwords(str_replace('_', ' ', $user['role']))); ?></td>
                    <td data-label="Associated Branch">
                        <?php echo $user['branch_name'] ? htmlspecialchars($user['branch_name']) : 'N/A'; ?>
                    </td>
                    <td data-label="Actions" class="action-links">
                        <a href="admin_edit_user.php?id=<?php echo $user['user_id']; ?>" class="btn btn-info btn-sm"><i class="fas fa-edit"></i> Edit</a>
                        <?php if ($user['user_id'] != $_SESSION['user_id']): // Prevent user from deleting themselves ?>
                            <a href="admin_delete_user_action.php?id=<?php echo $user['user_id']; ?>" class="btn btn-danger btn-sm confirm-delete"><i class="fas fa-trash-alt"></i> Delete</a>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>

<?php
include __DIR__ . '/../includes/footer.php';
$conn->close();
?>