<?php
// school_admission/public/admin_manage_branches.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/auth_check.php';

requireRole(['super_admin']); // Only Super Admin can access this page

$message = '';
if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    unset($_SESSION['message']);
}

// Fetch all branches
$branches = [];
$sql = "SELECT branch_id, branch_name, location, contact_person, contact_email, contact_phone FROM branches ORDER BY branch_name ASC";
$result = $conn->query($sql);

if ($result) {
    while ($row = $result->fetch_assoc()) {
        $branches[] = $row;
    }
    $result->free();
} else {
    $message = "<div class='message error'>Error fetching branches: " . $conn->error . "</div>";
}

include __DIR__ . '/../includes/header.php';
?>

<h2 class="mt-30">Manage Branches</h2>

<?php if (!empty($message)): ?>
    <?php echo $message; ?>
<?php endif; ?>

<div class="mb-20">
    <a href="admin_add_branch.php" class="btn btn-success"><i class="fas fa-plus"></i> Add New Branch</a>
</div>

<?php if (empty($branches)): ?>
    <div class="message info">No branches found. Please add a new branch.</div>
<?php else: ?>
    <table>
        <thead>
            <tr>
                <th>Branch ID</th>
                <th>Branch Name</th>
                <th>Location</th>
                <th>Contact Person</th>
                <th>Contact Email</th>
                <th>Contact Phone</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($branches as $branch): ?>
                <tr>
                    <td data-label="Branch ID"><?php echo htmlspecialchars($branch['branch_id']); ?></td>
                    <td data-label="Branch Name"><?php echo htmlspecialchars($branch['branch_name']); ?></td>
                    <td data-label="Location"><?php echo htmlspecialchars($branch['location']); ?></td>
                    <td data-label="Contact Person"><?php echo htmlspecialchars($branch['contact_person']); ?></td>
                    <td data-label="Contact Email"><?php echo htmlspecialchars($branch['contact_email']); ?></td>
                    <td data-label="Contact Phone"><?php echo htmlspecialchars($branch['contact_phone']); ?></td>
                    <td data-label="Actions" class="action-links">
                        <a href="admin_edit_branch.php?id=<?php echo $branch['branch_id']; ?>" class="btn btn-info btn-sm"><i class="fas fa-edit"></i> Edit</a>
                        <a href="admin_delete_branch_action.php?id=<?php echo $branch['branch_id']; ?>" class="btn btn-danger btn-sm confirm-delete"><i class="fas fa-trash-alt"></i> Delete</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>

<?php
include __DIR__ . '/../includes/footer.php';
$conn->close();
?>