<?php
// school_admission/public/admin_edit_course.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/auth_check.php';

requireRole(['super_admin']); // Only Super Admin can access this page

$message = '';
$course_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$course = null;

if ($course_id === 0) {
    $_SESSION['message'] = "<div class='message error'>Invalid course ID.</div>";
    redirect('admin_manage_courses.php');
}

// Fetch existing course data
$stmt = $conn->prepare("SELECT course_id, course_name, course_code, description FROM courses WHERE course_id = ?");
$stmt->bind_param("i", $course_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 1) {
    $course = $result->fetch_assoc();
} else {
    $_SESSION['message'] = "<div class='message error'>Course not found.</div>";
    redirect('admin_manage_courses.php');
}
$stmt->close();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $course_name = sanitize_input($_POST['course_name']);
    $course_code = sanitize_input($_POST['course_code']);
    $description = sanitize_input($_POST['description']);

    if (empty($course_name) || empty($course_code) || empty($description)) {
        $message = "<div class='message error'>All fields are required.</div>";
    } else {
        // Check if another course with this name or code already exists (excluding current course)
        $stmt_check = $conn->prepare("SELECT course_id FROM courses WHERE (course_name = ? OR course_code = ?) AND course_id != ?");
        $stmt_check->bind_param("ssi", $course_name, $course_code, $course_id);
        $stmt_check->execute();
        $stmt_check->store_result();

        if ($stmt_check->num_rows > 0) {
            $message = "<div class='message error'>A course with this name or code already exists.</div>";
        } else {
            $stmt_update = $conn->prepare("UPDATE courses SET course_name = ?, course_code = ?, description = ? WHERE course_id = ?");
            $stmt_update->bind_param("sssi", $course_name, $course_code, $description, $course_id);

            if ($stmt_update->execute()) {
                $_SESSION['message'] = "<div class='message success'>Course updated successfully!</div>";
                redirect('admin_manage_courses.php');
            } else {
                $message = "<div class='message error'>Error updating course: " . $stmt_update->error . "</div>";
            }
            $stmt_update->close();
        }
        $stmt_check->close();
    }
}

include __DIR__ . '/../includes/header.php';
?>

<h2 class="mt-30">Edit Course: <?php echo htmlspecialchars($course['course_name']); ?></h2>

<?php if (!empty($message)): ?>
    <?php echo $message; ?>
<?php endif; ?>

<form action="admin_edit_course.php?id=<?php echo $course_id; ?>" method="POST">
    <div class="form-group">
        <label for="course_name">Course Name:</label>
        <input type="text" id="course_name" name="course_name" required value="<?php echo htmlspecialchars($course['course_name']); ?>">
    </div>
    <div class="form-group">
        <label for="course_code">Course Code:</label>
        <input type="text" id="course_code" name="course_code" required value="<?php echo htmlspecialchars($course['course_code']); ?>">
    </div>
    <div class="form-group">
        <label for="description">Description:</label>
        <textarea id="description" name="description" rows="5" required><?php echo htmlspecialchars($course['description']); ?></textarea>
    </div>
    <div class="form-group">
        <button type="submit" class="btn btn-primary"><i class="fas fa-sync-alt"></i> Update Course</button>
        <a href="admin_manage_courses.php" class="btn btn-secondary">Cancel</a>
    </div>
</form>

<?php
include __DIR__ . '/../includes/footer.php';
$conn->close();
?>