<?php
// school_admission/public/admin_add_course.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/auth_check.php';

requireRole(['super_admin']); // Only Super Admin can access this page

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $course_name = sanitize_input($_POST['course_name']);
    $course_code = sanitize_input($_POST['course_code']);
    $description = sanitize_input($_POST['description']);

    if (empty($course_name) || empty($course_code) || empty($description)) {
        $message = "<div class='message error'>All fields are required.</div>";
    } else {
        // Check if course name or code already exists
        $stmt_check = $conn->prepare("SELECT course_id FROM courses WHERE course_name = ? OR course_code = ?");
        $stmt_check->bind_param("ss", $course_name, $course_code);
        $stmt_check->execute();
        $stmt_check->store_result();

        if ($stmt_check->num_rows > 0) {
            $message = "<div class='message error'>A course with this name or code already exists.</div>";
        } else {
            $stmt = $conn->prepare("INSERT INTO courses (course_name, course_code, description) VALUES (?, ?, ?)");
            $stmt->bind_param("sss", $course_name, $course_code, $description);

            if ($stmt->execute()) {
                $_SESSION['message'] = "<div class='message success'>Course added successfully!</div>";
                redirect('admin_manage_courses.php');
            } else {
                $message = "<div class='message error'>Error adding course: " . $stmt->error . "</div>";
            }
            $stmt->close();
        }
        $stmt_check->close();
    }
}

include __DIR__ . '/../includes/header.php';
?>

<h2 class="mt-30">Add New Course</h2>

<?php if (!empty($message)): ?>
    <?php echo $message; ?>
<?php endif; ?>

<form action="admin_add_course.php" method="POST">
    <div class="form-group">
        <label for="course_name">Course Name:</label>
        <input type="text" id="course_name" name="course_name" required value="<?php echo isset($_POST['course_name']) ? htmlspecialchars($_POST['course_name']) : ''; ?>">
    </div>
    <div class="form-group">
        <label for="course_code">Course Code:</label>
        <input type="text" id="course_code" name="course_code" required value="<?php echo isset($_POST['course_code']) ? htmlspecialchars($_POST['course_code']) : ''; ?>">
    </div>
    <div class="form-group">
        <label for="description">Description:</label>
        <textarea id="description" name="description" rows="5" required><?php echo isset($_POST['description']) ? htmlspecialchars($_POST['description']) : ''; ?></textarea>
    </div>
    <div class="form-group">
        <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Add Course</button>
        <a href="admin_manage_courses.php" class="btn btn-secondary">Cancel</a>
    </div>
</form>

<?php
include __DIR__ . '/../includes/footer.php';
$conn->close();
?>