<?php
// school_admission/public/admin_add_branch.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/auth_check.php';

requireRole(['super_admin']); // Only Super Admin can access this page

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $branch_name = sanitize_input($_POST['branch_name']);
    $location = sanitize_input($_POST['location']);
    $contact_person = sanitize_input($_POST['contact_person']);
    $contact_email = sanitize_input($_POST['contact_email']);
    $contact_phone = sanitize_input($_POST['contact_phone']);

    if (empty($branch_name) || empty($location) || empty($contact_person) || empty($contact_email) || empty($contact_phone)) {
        $message = "<div class='message error'>All fields are required.</div>";
    } else {
        // Check if branch name already exists
        $stmt_check = $conn->prepare("SELECT branch_id FROM branches WHERE branch_name = ?");
        $stmt_check->bind_param("s", $branch_name);
        $stmt_check->execute();
        $stmt_check->store_result();

        if ($stmt_check->num_rows > 0) {
            $message = "<div class='message error'>A branch with this name already exists.</div>";
        } else {
            $stmt = $conn->prepare("INSERT INTO branches (branch_name, location, contact_person, contact_email, contact_phone) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param("sssss", $branch_name, $location, $contact_person, $contact_email, $contact_phone);

            if ($stmt->execute()) {
                $_SESSION['message'] = "<div class='message success'>Branch added successfully!</div>";
                redirect('admin_manage_branches.php');
            } else {
                $message = "<div class='message error'>Error adding branch: " . $stmt->error . "</div>";
            }
            $stmt->close();
        }
        $stmt_check->close();
    }
}

include __DIR__ . '/../includes/header.php';
?>

<h2 class="mt-30">Add New Branch</h2>

<?php if (!empty($message)): ?>
    <?php echo $message; ?>
<?php endif; ?>

<form action="admin_add_branch.php" method="POST">
    <div class="form-group">
        <label for="branch_name">Branch Name:</label>
        <input type="text" id="branch_name" name="branch_name" required value="<?php echo isset($_POST['branch_name']) ? htmlspecialchars($_POST['branch_name']) : ''; ?>">
    </div>
    <div class="form-group">
        <label for="location">Location:</label>
        <textarea id="location" name="location" rows="3" required><?php echo isset($_POST['location']) ? htmlspecialchars($_POST['location']) : ''; ?></textarea>
    </div>
    <div class="form-group">
        <label for="contact_person">Contact Person:</label>
        <input type="text" id="contact_person" name="contact_person" required value="<?php echo isset($_POST['contact_person']) ? htmlspecialchars($_POST['contact_person']) : ''; ?>">
    </div>
    <div class="form-group">
        <label for="contact_email">Contact Email:</label>
        <input type="email" id="contact_email" name="contact_email" required value="<?php echo isset($_POST['contact_email']) ? htmlspecialchars($_POST['contact_email']) : ''; ?>">
    </div>
    <div class="form-group">
        <label for="contact_phone">Contact Phone:</label>
        <input type="text" id="contact_phone" name="contact_phone" required value="<?php echo isset($_POST['contact_phone']) ? htmlspecialchars($_POST['contact_phone']) : ''; ?>">
    </div>
    <div class="form-group">
        <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Add Branch</button>
        <a href="admin_manage_branches.php" class="btn btn-secondary">Cancel</a>
    </div>
</form>

<?php
include __DIR__ . '/../includes/footer.php';
$conn->close();
?>