<?php
// school_admission/public/about.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/auth_check.php';

// No login required for this page

include __DIR__ . '/../includes/header.php';
?>

<h2 class="mt-30 text-center">About Minna Institute of Technology and Innovation</h2>

<div class="about-section mb-30">
    <h3>Our Vision</h3>
    <p>To be a leading institution in technical and vocational education, fostering innovation and producing highly skilled and self-reliant graduates who contribute significantly to national development.</p>

    <h3>Our Mission</h3>
    <p>We are committed to providing accessible, high-quality, and industry-relevant technical and vocational education and training (TVET) through practical-oriented learning, research, and community engagement. Our aim is to empower youth with the skills needed for entrepreneurship, employment, and sustainable development.</p>

    <h3 id="courses">Our Programs & Courses</h3>
    <p>MITI offers National Innovative Diploma (NID) programs accredited by relevant bodies. Our courses are designed with a focus on practical application and industry needs. Some of our popular programs include:</p>
    <ul>
        <li>AUTOMOTIVE MECHATRONICS</li>
        <li>BUILDING CONSTRUCTION TECHNOLOGY (Options: Masonry, PoP & Tiling, Plumbing & Pipefitting, Carpentry & Joinery)</li>
        <li>BUSINESS MANAGEMENT & INFORMATION TECHNOLOGY</li>
        <li>ELECTRICAL ELECTRONICS TECHNOLOGY</li>
        <li>And many more, regularly updated to meet market demands.</li>
    </ul>
    <p>Our curriculum emphasizes hands-on training, ensuring our graduates are job-ready and capable of creating their own enterprises.</p>

    <h3 id="contact">Contact Us</h3>
    <p>We're here to help! Feel free to reach out to us with any inquiries.</p>
    <ul class="contact-list">
        <li><strong>Main Campus Address:</strong> Opp. Old Secretariat, Keteren, Gwari Rd, Minna, Niger State.</li>
        <li><strong>Email:</strong> <a href="mailto:info@miti.edu.ng">info@miti.edu.ng</a></li>
        <li><strong>Phone:</strong> <a href="tel:+2348012345678">+234 801 234 5678</a> (Example)</li>
        <li><strong>Office Hours:</strong> Monday - Friday, 9:00 AM - 4:00 PM</li>
    </ul>
    <p>You can also visit any of our community branches for admission support and inquiries.</p>
</div>

<?php
include __DIR__ . '/../includes/footer.php';
$conn->close();
?>