<?php
// school_admission/includes/header.php
// No direct access guard here as this is intended to be included by public PHP files.

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$base_url = '/school_admission/public/'; // Adjust if your root path is different

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MITI Admission System</title>
    <!-- Google Fonts - Montserrat and Open Sans for modern look -->
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;700&family=Open+Sans:wght@400;600&display=swap" rel="stylesheet">
    <!-- CSS path relative to the root of the public/ folder -->
    <link rel="stylesheet" href="<?php echo $base_url; ?>css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <div class="wrapper">
        <header class="main-header">
            <div class="container">
                <div class="logo">
                    <h1>MITI Admission</h1>
                </div>
                <!-- Mobile Navigation Toggle Button -->
                <button class="menu-toggle" aria-label="Toggle navigation">
                    <span class="hamburger"></span>
                </button>
                <nav class="main-nav">
                    <ul class="nav-list">
                        <?php if (isset($_SESSION['user_id'])): ?>
                            <li><a href="<?php echo $base_url; ?>dashboard.php"><span>Dashboard</span></a></li>
                            <?php if ($_SESSION['role'] === 'super_admin'): ?>
                                <li><a href="<?php echo $base_url; ?>admin_view_applications.php"><span>Applications</span></a></li>
                                <li><a href="<?php echo $base_url; ?>admin_manage_branches.php"><span>Branches</span></a></li>
                                <li><a href="<?php echo $base_url; ?>admin_manage_courses.php"><span>Courses</span></a></li>
                                <li><a href="<?php echo $base_url; ?>admin_manage_users.php"><span>Users</span></a></li>
                            <?php elseif ($_SESSION['role'] === 'branch_admin'): ?>
                                <li><a href="<?php echo $base_url; ?>branch_add_applicant.php"><span>Add Applicant</span></a></li>
                                <li><a href="<?php echo $base_url; ?>branch_view_applicants.php"><span>My Applicants</span></a></li>
                                <li><a href="<?php echo $base_url; ?>branch_print_letter.php"><span>Print Letters</span></a></li>
                            <?php endif; ?>
                            <li><a href="<?php echo $base_url; ?>logout.php"><span>Logout (<?php echo $_SESSION['username']; ?>)</span></a></li>
                        <?php else: ?>
                            <!-- Public navigation links -->
                            <li><a href="<?php echo $base_url; ?>index.php"><span>Home</span></a></li>
                            <li><a href="<?php echo $base_url; ?>about.php"><span>About Us</span></a></li>
                            <li><a href="<?php echo $base_url; ?>login.php"><span>Login</span></a></li>
                        <?php endif; ?>
                    </ul>
                </nav>
            </div>
        </header>
        <main class="content-area">
            <div class="container">
                <!-- Page content will go here -->